<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 3.7.0 Beta 5
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2008 Jelsoft Enterprises Ltd. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

function fetch_albuminfo($albumid)
{
	global $vbulletin;

	$albuminfo = $vbulletin->db->query_first("
		SELECT album.*, user.username
		FROM " . TABLE_PREFIX . "album AS album
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (album.userid = user.userid)
		WHERE album.albumid = " . intval($albumid)
	);
	if (!$albuminfo)
	{
		return array();
	}

	$albuminfo['title_html'] = fetch_word_wrapped_string(fetch_censored_text($albuminfo['title']));
	$albuminfo['description_html'] = nl2br(fetch_word_wrapped_string(fetch_censored_text($albuminfo['description'])));

	($hook = vBulletinHook::fetch_hook('album_fetch_albuminfo')) ? eval($hook) : false;

	return $albuminfo;
}

function fetch_pictureinfo($pictureid, $albumid)
{
	global $vbulletin;

	$pictureinfo = $vbulletin->db->query_first("
		SELECT picture.pictureid, picture.userid, picture.caption, picture.extension, picture.filesize,
			picture.width, picture.height, picture.reportthreadid,
			picture.idhash, picture.thumbnail_filesize, albumpicture.dateline, albumpicture.albumid
		FROM " . TABLE_PREFIX . "albumpicture AS albumpicture
		INNER JOIN " . TABLE_PREFIX . "picture AS picture ON (picture.pictureid = albumpicture.pictureid)
		WHERE albumpicture.albumid = " . intval($albumid) . "
			AND albumpicture.pictureid = " . intval($pictureid)
	);

	if (!$pictureinfo)
	{
		return array();
	}

	$pictureinfo['caption_html'] = nl2br(fetch_word_wrapped_string(fetch_censored_text($pictureinfo['caption'])));

	($hook = vBulletinHook::fetch_hook('album_fetch_pictureinfo')) ? eval($hook) : false;

	return $pictureinfo;
}

function prepare_pictureinfo_thumb($pictureinfo, $displaytypeinfo)
{
	$pictureinfo['caption_preview'] = fetch_censored_text(fetch_trimmed_title(
		$pictureinfo['caption'],
		$vbulletin->options['album_captionpreviewlen']
	));

	$pictureinfo['thumburl'] = ($pictureinfo['thumbnail_filesize'] ? fetch_picture_url($pictureinfo, $displaytypeinfo, true) : '');
	$pictureinfo['dimensions'] = ($pictureinfo['thumbnail_width'] ? "width=\"$pictureinfo[thumbnail_width]\" height=\"$pictureinfo[thumbnail_height]\"" : '');

	($hook = vBulletinHook::fetch_hook('album_prepare_thumb')) ? eval($hook) : false;

	return $pictureinfo;
}

function fetch_picture_location_info($navpictures_sql, $pictureid)
{
	global $vbphrase, $show, $vbulletin;

	$navpictures = array();
	$output = array();
	$cur_pic_position = -1;

	$key = 0;
	while ($navpicture = $vbulletin->db->fetch_array($navpictures_sql))
	{
		$navpictures["$key"] = $navpicture['pictureid'];

		if ($navpicture['pictureid'] == $pictureid)
		{
			$cur_pic_position = $key;
		}

		if ($cur_pic_position > 0 AND $key == $cur_pic_position + 1)
		{
			// we've matched at something other than the first entry,
			// and we're one past this current key, which means that we have a next and prev.
			// If we matched at key 0, we need to get the last entry, so keep going.
			break;
		}

		$key++;
	}

	$show['picture_nav'] = ($cur_pic_position > -1 AND sizeof($navpictures) > 1);

	if ($show['picture_nav'])
	{
		if (isset($navpictures[$cur_pic_position - 1]))
		{
			// have a previous pic
			$output['prev_pictureid'] = $navpictures[$cur_pic_position - 1];
			$output['prev_text'] = $vbphrase['previous_picture'];
			$output['prev_text_short'] = $vbphrase['prev'];
		}
		else
		{
			// go to end
			$output['prev_pictureid'] = end($navpictures);
			$output['prev_text'] = $vbphrase['last_picture'];
			$output['prev_text_short'] = $vbphrase['last'];
		}

		if (isset($navpictures[$cur_pic_position + 1]))
		{
			// have a next pic
			$output['next_pictureid'] = $navpictures[$cur_pic_position + 1];
			$output['next_text'] = $vbphrase['next_picture'];
			$output['next_text_short'] = $vbphrase['next'];
		}
		else
		{
			// go to beginning
			$output['next_pictureid'] = $navpictures[0];
			$output['next_text'] = $vbphrase['first_picture'];
			$output['next_text_short'] = $vbphrase['first'];
		}
	}

	$output['pic_position'] = $cur_pic_position + 1; // make it start at 1, instead of 0

	return $output;
}

/**
* Fetches the overage value for total number of pictures for a user.
*
* @param	integer	User ID to look for
* @param	integer	Maximum number of pics allowed; 0 means no limit
* @param	integer	Number of images they are currently uploading that aren't in the DB yet
*
* @return	integer	Amount of overage; <= 0 means no overage
*/
function fetch_count_overage($userid, $maxpics, $upload_count = 1)
{
	global $vbulletin;

	if (!$maxpics)
	{
		// never over
		return -1;
	}

	$count = $vbulletin->db->query_first("
		SELECT COUNT(*) AS total
		FROM " . TABLE_PREFIX . "picture
		WHERE userid = " . intval($userid)
	);

	return $count['total'] + $upload_count - $maxpics;
}

/**
* Fetches the overage value for total filesize of pictures for a user.
*
* @param	integer	User ID to look for
* @param	integer	Maximum total filesize allowed; 0 means no limit
* @param	integer	Number of bytes they are currently uploading that aren't in the DB yet
*
* @return	integer	Amount of overage; <= 0 means no overage
*/
function fetch_size_overage($userid, $maxsize, $upload_bytes = 0)
{
	global $vbulletin;

	if (!$maxsize)
	{
		// never over
		return -1;
	}

	$size = $vbulletin->db->query_first("
		SELECT SUM(filesize) AS totalsize
		FROM " . TABLE_PREFIX . "picture
		WHERE userid = " . intval($userid)
	);

	return $size['totalsize'] + $upload_bytes - $maxsize;
}

function can_view_private_albums($albumuserid)
{
	global $vbulletin;
	static $albumperms_cache = array();

	$albumuserid = intval($albumuserid);
	if (isset($albumperms_cache["$albumuserid"]))
	{
		return $albumperms_cache["$albumuserid"];
	}

	if ($vbulletin->userinfo['userid'] == $albumuserid)
	{
		$can_see_private = true;
	}
	else if ($vbulletin->userinfo['userid'] == 0)
	{
		$can_see_private = false;
	}
	else if (can_moderate(0, 'caneditalbumpicture') OR can_moderate(0, 'candeletealbumpicture'))
	{
		$can_see_private = true;
	}
	else
	{
		$friend_record = $vbulletin->db->query_first("
			SELECT userid
			FROM " . TABLE_PREFIX . "userlist
			WHERE userid = $albumuserid
				AND relationid = " . $vbulletin->userinfo['userid'] . "
				AND type = 'buddy'
		");
		$can_see_private = ($friend_record ? true : false);
	}

	($hook = vBulletinHook::fetch_hook('album_can_see_private')) ? eval($hook) : false;

	$albumperms_cache["$albumuserid"] = $can_see_private;
	return $can_see_private;
}

function can_view_profile_albums($albumuserid)
{
	global $vbulletin;

	$albumuserid = intval($albumuserid);

	return ($vbulletin->userinfo['userid'] == $albumuserid OR can_moderate(0, 'caneditalbumpicture') OR can_moderate(0, 'candeletealbumpicture')) ? true : false;
}

function fetch_picture_fs_path($pictureinfo, $thumb = false, $with_filename = true)
{
	global $vbulletin;

	if ($vbulletin->options['album_dataloc'] == 'fs_directthumb' AND $thumb == true)
	{
		$filepath = $vbulletin->options['album_thumbpath'];
	}
	else
	{
		$filepath = $vbulletin->options['album_picpath'];
	}

	$path = $filepath . '/' . floor($pictureinfo['pictureid'] / 1000);

	if ($with_filename)
	{
		if ($thumb)
		{
			$path .= "/$pictureinfo[idhash]_$pictureinfo[pictureid].$pictureinfo[extension]";
		}
		else
		{
			$path .= "/$pictureinfo[pictureid].picture";
		}
	}

	return $path;
}

function verify_picture_fs_path($pictureinfo, $thumb = false)
{
	global $vbulletin;

	if (!function_exists('vbmkdir'))
	{
		require_once(DIR . '/includes/functions_file.php');
	}

	$path = fetch_picture_fs_path($pictureinfo, $thumb, false);
	if (vbmkdir($path))
	{
		return $path;
	}
	else
	{
		return false;
	}
}

function fetch_picture_url($pictureinfo, $displaytypeinfo, $thumb = false)
{
	global $vbulletin;

	if ($vbulletin->options['album_dataloc'] == 'fs_directthumb' AND $thumb == true)
	{
		return $vbulletin->options['album_thumburl'] . '/' . floor($pictureinfo['pictureid'] / 1000)
			. "/$pictureinfo[idhash]_$pictureinfo[pictureid].$pictureinfo[extension]?dl=$pictureinfo[thumbnail_dateline]";
	}
	else
	{
		if (isset($displaytypeinfo['albumid']))
		{
			$displaybit = "&amp;albumid=$displaytypeinfo[albumid]";
		}
		else if (isset($displaytypeinfo['groupid']))
		{
			$displaybit = "&amp;groupid=$displaytypeinfo[groupid]";
		}
		else
		{
			$displaybit = '';
		}

		return 'picture.php?' . $vbulletin->session->vars['sessionurl']
			. "pictureid=$pictureinfo[pictureid]$displaybit&amp;dl=$pictureinfo[thumbnail_dateline]"
			. ($thumb ? '&amp;thumb=1' : '');
	}
}

function fetch_picture_dm_name()
{
	global $vbulletin;

	if ($vbulletin->options['album_dataloc'] == 'db')
	{
		return 'Picture_Database';
	}
	else
	{
		return 'Picture_Filesystem';
	}
}

/*======================================================================*\
|| ####################################################################
|| # CVS: $RCSfile$ - $Revision: 25686 $
|| ####################################################################
\*======================================================================*/
?>